#load packages
library(dplyr)
library(Seurat)
library(patchwork)


#read filtered gene count data
data <- read.csv("Gene count data.csv", header=TRUE, row.names=1)


#creating seurat object and filtering
ht <- CreateSeuratObject(counts = data, project = "5ht", min.cells = 3, min.features = 200)
ht <- subset(ht, subset = nFeature_RNA > 7500)


#assigning clusters from Ren et al.
meta_data <-  read.csv("Metadata of serotonin neuron cluster.csv")
Serotonin_cluster <- meta_data$Serotonin_cluster
names(Serotonin_cluster) <- colnames(x = ht)
ht <- AddMetaData(
   object = ht,
   metadata = Serotonin_cluster,
   col.name = 'Serotonin_cluster'
)


#normalization, feature selection, scaling
ht <- NormalizeData(ht, normalization.method = "LogNormalize", scale.factor = 10000)
ht <- FindVariableFeatures(ht, selection.method = "vst", nfeatures = 2000)
all.genes <- rownames(ht)
ht <- ScaleData(ht, features = all.genes)
#PCA
ht <- RunPCA(ht, features = VariableFeatures(object = ht))


#clustering
ht <- FindNeighbors(ht, dims = 1:11)
ht <- FindClusters(ht, resolution = 0.5)


#Fig1A
ht <- RunTSNE(ht, dims = 1:11)
DimPlot(object = ht, reduction = "tsne",group.by="Serotonin_cluster")


#Fig1B
FeaturePlot(ht, features = c("aNrxn1", "bNrxn1","aNrxn2","bNrxn2","aNrxn3","bNrxn3"),reduction="tsne")


#Fig1C
VlnPlot(ht, features = c("aNrxn1", "aNrxn2","aNrxn3","bNrxn1","bNrxn2","bNrxn3"),group.by="Serotonin_cluster")